<?php

namespace App\Filament\Pages;

use App\Filament\Widgets\RecentPayments;
use App\Filament\Widgets\RevenueChart;
use App\Filament\Widgets\StatsOverview;
use App\Filament\Widgets\TopTravelAgents;
use Filament\Pages\Page;
use UnitEnum;
use BackedEnum;

class Dashboard extends Page
{
    protected static BackedEnum|string|null $navigationIcon = 'heroicon-o-building-office';

    protected  string $view = 'filament.pages.dashboard';

    protected static ?int $navigationSort = -2;

    protected function getHeaderWidgets(): array
    {
        return [
            StatsOverview::class,
            RevenueChart::class,
        ];
    }

    protected function getFooterWidgets(): array
    {
        return [
            TopTravelAgents::class,
            RecentPayments::class,
        ];
    }

    public function getColumns(): int | string | array
    {
        return 2;
    }
}