<?php

namespace App\Filament\Pages;

use Filament\Pages\Page;
use BackedEnum;
use UnitEnum;

class PaymentSummary extends Page
{
    protected static string|BackedEnum|null $navigationIcon = 'heroicon-o-chart-pie';

    protected string $view = 'filament.pages.payment-summary';

    protected static  UnitEnum|string|null $navigationGroup = 'Analytics';

    protected static ?string $navigationLabel = 'Payment Summary';

    protected static ?int $navigationSort = 2;

    protected static ?string $title = 'Payment Summary';

    // Remove all widget methods for now
    protected function getHeaderWidgets(): array
    {
        return [];
    }

    protected function getFooterWidgets(): array
    {
        return [];
    }

    public function getColumns(): int
    {
        return 2;
    }
}