<?php

namespace App\Filament\Resources\AiUsageAnalytics;

use App\Filament\Resources\AiUsageAnalytics\Schemas\AiUsageAnalyticsForm;
use App\Filament\Resources\AiUsageAnalytics\Tables\AiUsageAnalyticsTable;
use BackedEnum;
use UnitEnum;
use Filament\Schemas\Schema;
//use Filament\Support\Icons\Heroicon;
use App\Filament\Resources\AiUsageAnalytics\Pages;
use App\Models\AiUsageLog;
use App\Models\TravelAgent;
use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\Select;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Actions;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\DB;


class AiUsageAnalyticsResource extends Resource
{
    protected static ?string $model = AiUsageLog::class;

    protected static  BackedEnum|string|null $navigationIcon = 'heroicon-o-chart-bar';

    protected static ?string $navigationLabel = 'AI Usage Analytics';

    protected static ?string $modelLabel = 'AI Usage Analytics';

    protected static ?string $pluralModelLabel = 'AI Usage Analytics';

    protected static  UnitEnum|string|null $navigationGroup = 'Analytics';

    public static function getNavigationBadge(): ?string
    {
        return static::getModel()::count();
    }

       public static function form(Schema $schema): Schema
    {
        return $schema
            ->schema([
                // This resource is primarily for viewing analytics, so form is minimal
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('travelAgent.name')
                    ->label('Travel Agent')
                    ->searchable()
                    ->sortable(),
                
                Tables\Columns\TextColumn::make('title')
                    ->searchable()
                    ->limit(50),
                
                Tables\Columns\TextColumn::make('word_count')
                    ->label('Words')
                    ->sortable()
                    ->alignCenter(),
                
                Tables\Columns\IconColumn::make('used_free_credit')
                    ->label('Free Credit')
                    ->boolean()
                    ->sortable()
                    ->alignCenter(),
                
                Tables\Columns\TextColumn::make('cost')
                    ->label('Cost (₹)')
                    ->money('INR')
                    ->sortable()
                    ->alignCenter(),
                
                Tables\Columns\TextColumn::make('created_at')
                    ->label('Date & Time')
                    ->dateTime()
                    ->sortable(),
            ])
            ->filters([
                Tables\Filters\SelectFilter::make('travel_agent_id')
                    ->label('Travel Agent')
                    ->options(TravelAgent::pluck('name', 'id'))
                    ->searchable(),
                
                Tables\Filters\TernaryFilter::make('used_free_credit')
                    ->label('Credit Type')
                    ->trueLabel('Free Credits')
                    ->falseLabel('Paid Credits'),
                
                Tables\Filters\Filter::make('created_at')
                    ->form([
                        DatePicker::make('created_from')
                            ->label('From Date'),
                        DatePicker::make('created_until')
                            ->label('To Date'),
                    ])
                    ->query(function (Builder $query, array $data): Builder {
                        return $query
                            ->when(
                                $data['created_from'],
                                fn (Builder $query, $date): Builder => $query->whereDate('created_at', '>=', $date),
                            )
                            ->when(
                                $data['created_until'],
                                fn (Builder $query, $date): Builder => $query->whereDate('created_at', '<=', $date),
                            );
                    }),
            ])
            ->actions([
                Actions\ViewAction::make(),
            ])
            ->bulkActions([
                Actions\BulkActionGroup::make([
                    Actions\DeleteBulkAction::make(),
                ]),
            ])
            ->defaultSort('created_at', 'desc')
            ->deferFilters();
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListAiUsageAnalytics::route('/'),
            'view' => Pages\ViewAiUsageAnalytics::route('/{record}'),
        ];
    }
}
