<?php

namespace App\Filament\Resources\PaymentAnalytics\Pages;

use App\Filament\Resources\PaymentAnalytics\PaymentAnalyticsResource;
use Filament\Actions;
use Filament\Resources\Pages\ViewRecord;

class ViewPaymentAnalytics extends ViewRecord
{
    protected static string $resource = PaymentAnalyticsResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\EditAction::make(),
            Actions\DeleteAction::make(),
            Actions\Action::make('back')
                ->label('Back to Analytics')
                ->url(static::$resource::getUrl('index'))
                ->color('gray'),
        ];
    }
}