<?php

namespace App\Filament\Widgets;

use App\Models\Payment;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget as BaseWidget;

class RecentPayments extends BaseWidget
{
    protected static ?string $heading = 'Recent Payments';
    
    protected int | string | array $columnSpan = 'half';
    protected static ?int $sort = 3;

    public function table(Table $table): Table
    {
        return $table
            ->query(
                Payment::with('travelAgent')
                    ->where('status', 'captured')
                    ->orderBy('created_at', 'desc')
                    ->limit(10)
            )
            ->columns([
                Tables\Columns\TextColumn::make('travelAgent.name')
                    ->label('Travel Agent')
                    ->searchable()
                    ->sortable(),
                    
                Tables\Columns\TextColumn::make('amount')
                    ->label('Amount')
                    ->money('INR')
                    ->sortable(),
                    
                Tables\Columns\TextColumn::make('entity_type')
                    ->label('Type')
                    ->formatStateUsing(fn ($state) => match($state) {
                        'plan' => 'Subscription',
                        'top_up' => 'Top-up',
                        default => ucfirst($state)
                    })
                    ->badge()
                    ->color(fn ($state) => match($state) {
                        'plan' => 'success',
                        'top_up' => 'info',
                        default => 'gray'
                    }),
                    
                Tables\Columns\TextColumn::make('created_at')
                    ->label('Date')
                    ->dateTime()
                    ->sortable(),
            ])
            ->paginated(false);
    }
}