<?php

namespace App\Http\Controllers\SuperAdmin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class SystemSettingController extends Controller
{
    public function index()
    {
        $settings = [
            'app_name' => config('app.name', 'TripCup'),
            'app_url' => config('app.url'),
            'razorpay_enabled' => !empty(env('RAZORPAY_KEY_ID')),
            'firebase_enabled' => !empty(env('FIREBASE_CREDENTIALS')),
            'mail_enabled' => !empty(env('MAIL_MAILER')),
        ];

        return response()->json($settings);
    }

    public function update(Request $request)
    {
        $validated = $request->validate([
            'app_name' => 'sometimes|string|max:255',
            'maintenance_mode' => 'sometimes|boolean',
            'registration_enabled' => 'sometimes|boolean',
            'ai_features_enabled' => 'sometimes|boolean',
        ]);

        // In a real application, you'd save these to database or .env file
        // For now, we'll return the validated data
        return response()->json([
            'message' => 'Settings updated successfully',
            'settings' => $validated
        ]);
    }

    public function getConfig()
    {
        $config = [
            'services' => [
                'razorpay' => [
                    'key_id' => env('RAZORPAY_KEY_ID') ? '***' . substr(env('RAZORPAY_KEY_ID'), -4) : 'Not set',
                    'enabled' => !empty(env('RAZORPAY_KEY_ID')),
                ],
                'firebase' => [
                    'enabled' => !empty(env('FIREBASE_CREDENTIALS')),
                ],
                'mail' => [
                    'driver' => env('MAIL_MAILER'),
                    'enabled' => !empty(env('MAIL_MAILER')),
                ],
            ],
            'app' => [
                'name' => config('app.name'),
                'env' => config('app.env'),
                'debug' => config('app.debug'),
                'url' => config('app.url'),
            ],
        ];

        return response()->json($config);
    }
}