<?php
// app/Models/AiUsageLog.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AiUsageLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'travel_agent_id',
        'ai_key_id',
        'title',
        'prompt_used',
        'word_count',
        'used_free_credit',
        'used_top_up_words', // ✅ ADD THIS
        'cost'
    ];

    protected $casts = [
        'used_free_credit' => 'boolean',
        'cost' => 'decimal:2',
        'word_count' => 'integer',
        'used_top_up_words' => 'integer', // ✅ ADD THIS
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    // Relationship with TravelAgent
    public function travelAgent()
    {
        return $this->belongsTo(TravelAgent::class);
    }

    // Relationship with AiKey
    public function aiKey()
    {
        return $this->belongsTo(AiKey::class);
    }

    // Scope for free credit usage
    public function scopeFreeCredits($query)
    {
        return $query->where('used_free_credit', true);
    }

    // Scope for paid credit usage
    public function scopePaidCredits($query)
    {
        return $query->where('used_free_credit', false);
    }

    // Scope for this month
    public function scopeThisMonth($query)
    {
        return $query->whereMonth('created_at', now()->month)
                    ->whereYear('created_at', now()->year);
    }
}