<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InvoiceDayExtraService extends Model
{
    use HasFactory;

    protected $fillable = [
        'invoice_day_id',
        'extra_service_id',
        'price',
        'quantity',  // new
    ];

    public function invoiceDay()
    {
        return $this->belongsTo(InvoiceDay::class);
    }

    public function extraService()
    {
        return $this->belongsTo(ExtraService::class);
    }
}
