<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Payment extends Model
{
    use HasFactory;

    protected $fillable = [
        'travel_agent_id',
        'razorpay_order_id',
        'razorpay_payment_id',
        'razorpay_signature',
        'amount',
        'currency',
        'status',
        'entity_type',
        'entity_id',
        'notes',
    ];

    public function travelAgent()
    {
        return $this->belongsTo(TravelAgent::class);
    }
}
