<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Service extends Model
{
    use HasFactory;

    protected $fillable = ['travel_agent_id', 'name', 'type_variation'];

    protected $casts = [
        'type_variation' => 'array', // JSON field
    ];

    public function travelAgent()
    {
        return $this->belongsTo(TravelAgent::class);
    }
}

