<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SuperAdminLoginLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'super_admin_id',
        'ip_address',
        'user_agent',
        'login_at',
        'logout_at',
        'session_id',
        'login_successful',
        'failure_reason',
    ];

    protected $casts = [
        'login_at' => 'datetime',
        'logout_at' => 'datetime',
        'login_successful' => 'boolean',
    ];

    public function superAdmin()
    {
        return $this->belongsTo(SuperAdmin::class);
    }
}