<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TopUpOption extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'words',
        'price',
        'is_active',
        'description',
        'is_best_value',
    ];

    protected $casts = [
        'price' => 'decimal:2',
        'is_active' => 'boolean',
        'is_best_value' => 'boolean',
    ];
}
