<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use App\Models\TravelAgent; // <-- Correctly imported

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int,string>
     */
    protected $fillable = [
        'travel_agent_id',   // maps user to travel agent
        'is_admin',      // <-- ADD THIS
        'name',
        'email',
        'mobile',            // for OTP login
        'firebase_uid',      // NEW: Firebase UID for authentication
        'password',
        'pin_code',          // hashed PIN for quick login
        'is_active', // <-- ADDED
        'access_expires_at', // session/PIN expiration
        'last_login_at',     // last login timestamp
        'last_login_method', // OTP / PIN / Password
        'otp',               // temporary OTP
        'otp_expires_at'     // OTP expiration timestamp
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int,string>
     */
    protected $hidden = [
        'password',
        'pin_code',
        'otp',
        'firebase_uid',      // NEW: Hide Firebase UID from responses
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string,string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'access_expires_at' => 'datetime',
        'last_login_at' => 'datetime',
        'otp_expires_at' => 'datetime',
        'password' => 'hashed',
    ];

    /**
     * User belongs to Travel Agent.
     */
    public function travelAgent()
    {
        // Assuming your 'travel_agent_id' column in 'users' links to 'id' in 'travel_agents'
        return $this->belongsTo(TravelAgent::class, 'travel_agent_id');
    }

     // Optional: Add convenient helper methods
    public function getIsAdminAttribute(): bool
    {
        return (bool) $this->attributes['is_admin'];
    }

    public function getIsActiveAttribute(): bool
    {
        return (bool) $this->attributes['is_active'];
    }
}