<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Config;
use App\Models\MailConfig;
use App\Services\SeasonalPriceService;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register()
    {
        $this->app->singleton(SeasonalPriceService::class, function ($app) {
            return new SeasonalPriceService();
        });
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //
    }

    /**
     * Dynamically set mail configuration for a given travel agent.
     *
     * @param int $travelAgentId
     * @return void
     */
    public static function setMailConfig(int $travelAgentId): void
    {
        $config = MailConfig::where('travel_agent_id', $travelAgentId)->first();

        if ($config) {
            // Configure dynamic mailer
            Config::set('mail.mailers.dynamic', [
                'transport' => $config->mailer ?? 'smtp',
                'host' => $config->host,
                'port' => $config->port,
                'encryption' => $config->encryption,
                'username' => $config->username,
                'password' => $config->password,
                'timeout' => null,
                'auth_mode' => null,
            ]);

            // Set default "from" address
            Config::set('mail.from', [
                'address' => $config->from_address,
                'name' => $config->from_name,
            ]);
        }
    }
}

