<?php
// app/Services/MailService.php

namespace App\Services;

use App\Models\MailConfig;
use App\Providers\AppServiceProvider;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Config;
use Exception;

class MailService
{
    /**
     * Send HTML email using travel agent's mail configuration
     */
    public static function sendEmail(int $travelAgentId, array $emailData)
    {
        try {
            // Set dynamic mail configuration
            AppServiceProvider::setMailConfig($travelAgentId);

            // Use the dynamic mailer
            Mail::mailer('dynamic')->send($emailData['view'], $emailData['data'], function ($message) use ($emailData) {
                $message->to($emailData['to'])
                        ->subject($emailData['subject']);

                // Add CC if provided
                if (isset($emailData['cc'])) {
                    $message->cc($emailData['cc']);
                }

                // Add BCC if provided
                if (isset($emailData['bcc'])) {
                    $message->bcc($emailData['bcc']);
                }

                // Attach files if provided
                if (isset($emailData['attachments'])) {
                    foreach ($emailData['attachments'] as $attachment) {
                        $message->attach($attachment['path'], [
                            'as' => $attachment['name'] ?? null,
                            'mime' => $attachment['mime'] ?? null,
                        ]);
                    }
                }
            });

            return ['success' => true, 'message' => 'Email sent successfully'];

        } catch (Exception $e) {
            return [
                'success' => false, 
                'message' => 'Failed to send email: ' . $e->getMessage()
            ];
        }
    }
}