<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->id();
            $table->foreignId('travel_agent_id')->constrained('travel_agents')->onDelete('cascade');
            $table->enum('type', ['Quotation', 'Billing']);
            $table->string('package_name');
            $table->integer('duration_days');
            $table->integer('no_of_pax');
            $table->date('tour_start_day');
            $table->decimal('tax_percentage', 5, 2)->default(18);
            $table->decimal('discount_amount', 10, 2)->default(0);
            $table->decimal('final_price', 10, 2);
            $table->enum('status', ['Pending', 'Finalized']);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('invoices');
    }

};
