<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('invoice_day_extra_services', function (Blueprint $table) {
            $table->id();
            $table->foreignId('invoice_day_id')->constrained('invoice_days')->onDelete('cascade');
            $table->foreignId('extra_service_id')->constrained('extra_services')->onDelete('cascade');
            $table->decimal('price', 10, 2);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('invoice_day_extra_services');
    }

};
