<?php
// database/migrations/2025_09_21_000001_create_ai_usage_logs_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAiUsageLogsTable extends Migration
{
    public function up()
    {
        Schema::create('ai_usage_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('travel_agent_id')->constrained()->onDelete('cascade');
            $table->foreignId('ai_key_id')->constrained()->onDelete('cascade');
            $table->string('title');
            $table->text('prompt_used');
            $table->integer('word_count');
            $table->boolean('used_free_credit')->default(true);
            $table->decimal('cost', 8, 2)->default(0);
            $table->timestamps();
            
            $table->index('travel_agent_id');
            $table->index('created_at');
        });
    }

    public function down()
    {
        Schema::dropIfExists('ai_usage_logs');
    }
}