<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('ai_plans', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // Basic, Pro, Enterprise
            $table->string('display_name'); // Basic Plan, Pro Plan, etc.
            $table->integer('monthly_words');
            $table->integer('carry_forward_months')->default(0);
            $table->decimal('top_up_rate', 8, 3); // 0.120, 0.100, 0.080
            $table->decimal('price', 8, 2);
            $table->text('description')->nullable();
            $table->integer('free_words_included')->default(500); // Always includes 500 free words
            $table->boolean('is_active')->default(true);
            $table->integer('sort_order')->default(0);
            $table->json('features')->nullable(); // List of features
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('ai_plans');
    }
};