<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        // Remove plan-specific columns (they'll be in ai_plans now)
        Schema::table('ai_subscriptions', function (Blueprint $table) {
            $table->dropColumn(['plan_name', 'monthly_words', 'carry_forward_months', 'top_up_rate']);
            
            // Add reference to ai_plans
            $table->foreignId('plan_id')->after('travel_agent_id')
                  ->constrained('ai_plans')
                  ->onDelete('cascade');
                  
            // Add status and billing cycle
            $table->enum('status', ['active', 'canceled', 'expired', 'pending'])->default('pending');
            $table->string('stripe_subscription_id')->nullable();
            $table->string('stripe_price_id')->nullable();
        });
    }

    public function down()
    {
        Schema::table('ai_subscriptions', function (Blueprint $table) {
            $table->dropForeign(['plan_id']);
            $table->dropColumn(['plan_id', 'status', 'stripe_subscription_id', 'stripe_price_id']);
            
            // Re-add dropped columns
            $table->string('plan_name');
            $table->integer('monthly_words');
            $table->integer('carry_forward_months')->default(3);
            $table->decimal('top_up_rate', 8, 2);
        });
    }
};