<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('top_up_options', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->integer('words');
            $table->decimal('price', 8, 2);
            $table->boolean('is_active')->default(true);
            $table->string('description')->nullable();
            $table->boolean('is_best_value')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('top_up_options');
    }
};
