<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up() {
        Schema::create('trip_payments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('invoice_id')->constrained()->onDelete('cascade');
            $table->enum('type', ['Advance', 'Installment', 'Full', 'Refund'])->default('Advance');
            $table->decimal('amount', 12, 2);
            $table->string('payment_method')->default('Bank Transfer');
            $table->string('transaction_id')->nullable();
            $table->string('reference_number')->nullable();
            $table->date('payment_date');
            $table->text('notes')->nullable();
            $table->enum('status', ['Pending', 'Completed', 'Failed', 'Refunded'])->default('Completed');
            $table->timestamps();
            
            $table->index(['invoice_id', 'payment_date']);
            $table->index('transaction_id');
        });
    }

    public function down() {
        Schema::dropIfExists('trip_payments');
    }
};