<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up() {
        Schema::table('invoices', function (Blueprint $table) {
            $table->decimal('total_paid_amount', 12, 2)->default(0.00);
            $table->decimal('remaining_amount', 12, 2)->default(0.00);
            $table->decimal('refundable_amount', 12, 2)->default(0.00);
            $table->enum('payment_status', ['Unpaid', 'Partially Paid', 'Fully Paid'])->default('Unpaid');
        });
    }

    public function down() {
        Schema::table('invoices', function (Blueprint $table) {
            $table->dropColumn(['total_paid_amount', 'remaining_amount', 'refundable_amount', 'payment_status']);
        });
    }
};