<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
        {
            Schema::create('mail_configs', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('travel_agent_id');
                $table->string('mailer')->default('smtp');
                $table->string('host');
                $table->integer('port')->default(587);
                $table->string('encryption')->nullable(); // tls or ssl
                $table->string('username');
                $table->string('password');
                $table->string('from_address');
                $table->string('from_name');
                $table->timestamps();

                $table->foreign('travel_agent_id')->references('id')->on('travel_agents')->onDelete('cascade');
            });
        }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('mail_configs');
    }
};
