<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('system_settings', function (Blueprint $table) {
            $table->id();
            $table->string('key')->unique();
            $table->text('value')->nullable();
            $table->string('type')->default('string'); // string, boolean, integer, json
            $table->text('description')->nullable();
            $table->timestamps();
        });

        // Insert default settings
        DB::table('system_settings')->insert([
            ['key' => 'app_name', 'value' => 'TripCup', 'type' => 'string', 'description' => 'Application name'],
            ['key' => 'registration_enabled', 'value' => '1', 'type' => 'boolean', 'description' => 'Allow new registrations'],
            ['key' => 'ai_features_enabled', 'value' => '1', 'type' => 'boolean', 'description' => 'Enable AI features'],
            ['key' => 'maintenance_mode', 'value' => '0', 'type' => 'boolean', 'description' => 'Maintenance mode'],
        ]);
    }

    public function down(): void
    {
        Schema::dropIfExists('system_settings');
    }
};