<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('invoices', function (Blueprint $table) {
            // Add trip_code column (VARCHAR(20) UNIQUE AFTER id)
            $table->string('trip_code', 20)->unique()->after('id');

            // Add user_id column (BIGINT UNSIGNED AFTER travel_agent_id)
            $table->unsignedBigInteger('user_id')->nullable()->after('travel_agent_id');

            // Add foreign key constraint
            // Ensure 'users' table exists and 'id' is unsigned BIGINT
            $table->foreign('user_id', 'invoices_user_id_foreign') 
                  ->references('id')->on('users')
                  ->onDelete('set null'); 
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('invoices', function (Blueprint $table) {
            // Drop foreign key constraint
            $table->dropForeign('invoices_user_id_foreign');
            
            // Drop columns
            $table->dropColumn('user_id');
            $table->dropColumn('trip_code');
        });
    }
};