<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSeasonalCacheTable extends Migration
{
    public function up()
    {
        Schema::create('seasonal_cache', function (Blueprint $table) {
            $table->id();
            $table->date('date')->unique();
            $table->decimal('total_hike_percentage', 5, 2)->default(0);
            $table->json('applicable_sessions')->nullable();
            $table->integer('cache_year');
            $table->timestamps();
            
            $table->index(['date']);
            $table->index(['cache_year']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('seasonal_cache');
    }
}