<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('invoice_days', function (Blueprint $table) {
            $table->decimal('seasonal_hike_percentage', 5, 2)
                  ->default(0.00)
                  ->after('day_date')
                  ->comment('Total seasonal price increase percentage for this day');
            
            $table->json('seasonal_sessions')
                  ->nullable()
                  ->after('seasonal_hike_percentage')
                  ->comment('JSON array of seasonal sessions applied to this day with names and percentages');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('invoice_days', function (Blueprint $table) {
            $table->dropColumn(['seasonal_hike_percentage', 'seasonal_sessions']);
        });
    }
};