<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\TopUpOption;

class TopUpOptionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        TopUpOption::updateOrCreate(
            ['words' => 1000],
            [
                'title' => 'Small Pack',
                'price' => 150.00,
                'description' => 'A quick boost for your word count.',
                'is_best_value' => false,
                'is_active' => true,
            ]
        );

        TopUpOption::updateOrCreate(
            ['words' => 5000],
            [
                'title' => 'Medium Pack',
                'price' => 600.00,
                'description' => 'Best value for frequent users.',
                'is_best_value' => true,
                'is_active' => true,
            ]
        );

        TopUpOption::updateOrCreate(
            ['words' => 10000],
            [
                'title' => 'Large Pack',
                'price' => 1000.00,
                'description' => 'For power users and teams.',
                'is_best_value' => false,
                'is_active' => true,
            ]
        );
    }
}
