<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    public function run(): void
    {
        $travelAgents = DB::table('travel_agents')->get();

        foreach ($travelAgents as $agent) {
            // Create 2 users per travel agent
            DB::table('users')->insert([
                [
                    'travel_agent_id' => $agent->id,
                    'name' => 'John Doe',
                    'email' => 'john_'.$agent->id.'@example.com',
                    'mobile' => '90000000'.$agent->id.'1',
                    'password' => Hash::make('password123'),
                    'pin_code' => Hash::make('1234'), // simple PIN
                    'created_at' => now(),
                    'updated_at' => now(),
                ],
                [
                    'travel_agent_id' => $agent->id,
                    'name' => 'Jane Smith',
                    'email' => 'jane_'.$agent->id.'@example.com',
                    'mobile' => '90000000'.$agent->id.'2',
                    'password' => Hash::make('password123'),
                    'pin_code' => Hash::make('5678'),
                    'created_at' => now(),
                    'updated_at' => now(),
                ]
            ]);
        }
    }
}
