<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Trip Plan - {{ $invoice['package_name'] ?? 'Travel Package' }}</title>
    <style>
        /* Reset and Base Styles */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f8f9fa;
            margin: 0;
            padding: 20px;
        }
        
        .email-container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }
        
        /* Letterhead Header */
        .letterhead {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 40px 30px;
            text-align: center;
            position: relative;
            overflow: hidden;
        }
        
        .letterhead::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: rgba(255,255,255,0.1);
            transform: rotate(45deg);
        }
        
        .company-name {
            font-size: 2.5em;
            font-weight: bold;
            margin-bottom: 10px;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
            position: relative;
            z-index: 1;
        }
        
        .company-tagline {
            font-size: 1.2em;
            opacity: 0.9;
            margin-bottom: 20px;
            position: relative;
            z-index: 1;
        }
        
        .company-info {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin-top: 25px;
            position: relative;
            z-index: 1;
        }
        
        .info-item {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            font-size: 0.9em;
        }
        
        /* Content Sections */
        .content-section {
            padding: 30px;
            border-bottom: 1px solid #e9ecef;
        }
        
        .section-title {
            color: #2c3e50;
            font-size: 1.4em;
            font-weight: 600;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #3498db;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .section-title i {
            color: #3498db;
        }
        
        /* Trip Summary Grid */
        .summary-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin-bottom: 20px;
        }
        
        .summary-card {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            padding: 20px;
            border-radius: 10px;
            text-align: center;
            border-left: 4px solid #3498db;
        }
        
        .summary-value {
            font-size: 1.5em;
            font-weight: bold;
            color: #2c3e50;
            margin: 5px 0;
        }
        
        .summary-label {
            font-size: 0.9em;
            color: #6c757d;
        }
        
        /* Customer Details */
        .customer-details {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 15px;
        }
        
        .detail-item {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 10px;
            background: #f8f9fa;
            border-radius: 8px;
        }
        
        .detail-icon {
            width: 40px;
            height: 40px;
            background: #3498db;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
        }
        
        /* Price Breakdown */
        .price-table {
            width: 100%;
            border-collapse: collapse;
            margin: 15px 0;
        }
        
        .price-table td {
            padding: 12px;
            border-bottom: 1px solid #e9ecef;
        }
        
        .price-table tr:last-child td {
            border-bottom: none;
            font-weight: bold;
            background: #e8f4fd;
        }
        
        .price-table .amount {
            text-align: right;
            font-weight: 600;
        }
        
        /* Payment Status */
        .payment-status {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            border-radius: 10px;
            padding: 20px;
            margin: 15px 0;
        }
        
        .progress-bar {
            height: 8px;
            background: #e9ecef;
            border-radius: 4px;
            margin: 10px 0;
            overflow: hidden;
        }
        
        .progress-fill {
            height: 100%;
            background: linear-gradient(90deg, #28a745, #20c997);
            border-radius: 4px;
        }
        
        /* Itinerary */
        .day-card {
            background: #f8f9fa;
            border-radius: 10px;
            margin: 15px 0;
            overflow: hidden;
            border-left: 4px solid #3498db;
        }
        
        .day-header {
            background: #e8f4fd;
            padding: 15px 20px;
            font-weight: 600;
            color: #2c3e50;
        }
        
        .day-content {
            padding: 20px;
        }
        
        .activity-list {
            list-style: none;
        }
        
        .activity-item {
            padding: 8px 0;
            border-bottom: 1px solid #e9ecef;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .activity-item:last-child {
            border-bottom: none;
        }
        
        .activity-icon {
            color: #3498db;
            font-weight: bold;
        }
        
        /* Footer */
        .footer {
            background: #2c3e50;
            color: white;
            padding: 30px;
            text-align: center;
        }
        
        .footer-logo {
            font-size: 2em;
            font-weight: bold;
            margin-bottom: 10px;
            color: #3498db;
        }
        
        .thank-you {
            font-size: 1.3em;
            margin: 15px 0;
            color: #ecf0f1;
        }
        
        /* Responsive */
        @media (max-width: 768px) {
            .email-container {
                margin: 10px;
                border-radius: 10px;
            }
            
            .letterhead {
                padding: 30px 20px;
            }
            
            .company-name {
                font-size: 2em;
            }
            
            .content-section {
                padding: 20px;
            }
            
            .summary-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <div class="email-container">
                <div class="letterhead">
            <div class="company-name">{{ $travelAgent['name'] ?? 'Travel Agency' }}</div>
            <div class="company-tagline">Creating Unforgettable Travel Experiences</div>
            
            <div class="company-info">
                @if(!empty($travelAgent['phone']))
                <div class="info-item">
                    📞 {{ $travelAgent['phone'] }}
                </div>
                @endif
                
                @if(!empty($travelAgent['email']))
                <div class="info-item">
                    ✉️ {{ $travelAgent['email'] }}
                </div>
                @endif
                
                @if(!empty($travelAgent['address']))
                <div class="info-item">
                    📍 {{ $travelAgent['address'] }}
                </div>
                @endif
                
                @if(!empty($travelAgent['gst_number']))
                <div class="info-item">
                    🏢 GST: {{ $travelAgent['gst_number'] }}
                </div>
                @endif
            </div>
        </div>

                <div class="content-section">
            <div class="section-title">
                ✈️ TRIP OVERVIEW
            </div>
            
            <div style="text-align: center; margin-bottom: 25px;">
                <h2 style="color: #2c3e50; font-size: 1.8em; margin-bottom: 10px;">
                    {{ $invoice['package_name'] ?? 'Travel Package' }}
                </h2>
                <p style="color: #6c757d; font-size: 1.1em;">
                    Your dream vacation awaits! Here's your detailed trip plan.
                </p>
            </div>

            <div class="summary-grid">
                <div class="summary-card">
                    <div class="summary-label">Duration</div>
                    <div class="summary-value">{{ count($invoice['trip_days'] ?? []) }} Days</div>
                </div>
                <div class="summary-card">
                    <div class="summary-label">Travelers</div>
                    <div class="summary-value">{{ $invoice['no_of_pax'] ?? 0 }} Persons</div>
                </div>
                <div class="summary-card">
                    <div class="summary-label">Start Date</div>
                    <div class="summary-value">{{ $startDate ?? 'N/A' }}</div>
                </div>
                <div class="summary-card">
                    <div class="summary-label">End Date</div>
                    <div class="summary-value">{{ $endDate ?? 'N/A' }}</div>
                </div>
            </div>
        </div>

                <div class="content-section">
            <div class="section-title">
                👤 GUEST INFORMATION
            </div>
            
            <div class="customer-details">
                <div class="detail-item">
                    <div class="detail-icon">👤</div>
                    <div>
                        <div style="font-weight: 600;">{{ $invoice['customer_name'] ?? 'Customer' }}</div>
                        <div style="font-size: 0.9em; color: #6c757d;">Primary Guest</div>
                    </div>
                </div>
                
                <div class="detail-item">
                    <div class="detail-icon">📞</div>
                    <div>
                        <div style="font-weight: 600;">{{ $invoice['customer_phone_number'] ?? 'N/A' }}</div>
                        <div style="font-size: 0.9em; color: #6c757d;">Phone</div>
                    </div>
                </div>
                
                <div class="detail-item">
                    <div class="detail-icon">💬</div>
                    <div>
                        <div style="font-weight: 600;">{{ $invoice['customer_whatsapp'] ?? 'N/A' }}</div>
                        <div style="font-size: 0.9em; color: #6c757d;">WhatsApp</div>
                    </div>
                </div>
                
                <div class="detail-item">
                    <div class="detail-icon">✉️</div>
                    <div>
                        <div style="font-weight: 600;">{{ $invoice['customer_email'] ?? 'N/A' }}</div>
                        <div style="font-size: 0.9em; color: #6c757d;">Email</div>
                    </div>
                </div>
            </div>
        </div>

                <div class="content-section">
            <div class="section-title">
                💰 PRICE BREAKDOWN
            </div>
            
            <table class="price-table">
                <tr>
                    <td>Total Package Amount</td>
                    <td class="amount">₹{{ number_format(($invoice['billed_amount'] ?? 0) + ($invoice['margin_amount'] ?? 0), 2) }}</td>
                </tr>
                <tr>
                    <td>Tax ({{ $invoice['tax_percentage'] ?? 0 }}%)</td>
                    <td class="amount">₹{{ number_format($invoice['tax_amount'] ?? 0, 2) }}</td>
                </tr>
                <tr>
                    <td>Discount</td>
                    <td class="amount">-₹{{ number_format($invoice['discount_amount'] ?? 0, 2) }}</td>
                </tr>
                <tr style="background: #e8f4fd;">
                    <td><strong>Final Amount</strong></td>
                    <td class="amount"><strong>₹{{ number_format($invoice['final_price'] ?? 0, 2) }}</strong></td>
                </tr>
                <tr>
                    <td>Per Person</td>
                    <td class="amount">₹{{ number_format(($invoice['final_price'] ?? 0) / max(1, ($invoice['no_of_pax'] ?? 1)), 2) }}</td>
                </tr>
            </table>
        </div>

                <div class="content-section">
            <div class="section-title">
                💳 PAYMENT INFORMATION
            </div>
            
            <div class="payment-status">
                <div style="display: flex; justify-content: space-between; margin-bottom: 10px;">
                    <span>Total Amount: <strong>₹{{ number_format($invoice['final_price'] ?? 0, 2) }}</strong></span>
                    <span>Paid: <strong>₹{{ number_format($invoice['total_paid_amount'] ?? 0, 2) }}</strong></span>
                    <span>Due: <strong>₹{{ number_format($invoice['remaining_amount'] ?? 0, 2) }}</strong></span>
                </div>
                
                <div class="progress-bar">
                    <div class="progress-fill" style="width: {{ $paymentPercentage ?? 0 }}%"></div>
                </div>
                
                <div style="text-align: center; color: #6c757d; font-size: 0.9em;">
                    {{ number_format($paymentPercentage ?? 0, 1) }}% Paid • Status: {{ $invoice['payment_status'] ?? 'Pending' }}
                </div>
            </div>

            @if(!empty($payments))
            <div style="margin-top: 20px;">
                <h4 style="color: #2c3e50; margin-bottom: 15px;">Payment History</h4>
                @foreach($payments as $payment)
                <div style="background: #f8f9fa; padding: 12px; border-radius: 8px; margin-bottom: 8px; border-left: 3px solid #3498db;">
                    <div style="display: flex; justify-content: space-between; align-items: center;">
                        <span><strong>{{ $payment['type'] ?? 'Payment' }}</strong> • {{ $payment['payment_method'] ?? 'N/A' }}</span>
                        <span style="font-weight: 600;">₹{{ number_format($payment['amount'] ?? 0, 2) }}</span>
                    </div>
                    <div style="font-size: 0.9em; color: #6c757d; margin-top: 5px;">
                        {{ $payment['payment_date'] ?? 'N/A' }} • {{ $payment['status'] ?? 'Pending' }}
                    </div>
                </div>
                @endforeach
            </div>
            @endif
        </div>

                <div class="content-section">
            <div class="section-title">
                📅 DAY-WISE ITINERARY
            </div>
            
            @foreach($invoice['trip_days'] ?? [] as $day)
            <div class="day-card">
                <div class="day-header">
                    Day {{ $day['day_number'] ?? 1 }} - **{{ $day['day_date'] ?? 'N/A' }}**
                </div>
                <div class="day-content">
                   @if(!empty($day['day_descriptions']))
                        <h4 style="color: #2c3e50; margin-bottom: 10px;">📝 Day Overview</h4>
                        <ul class="activity-list">
                            @foreach($day['day_descriptions'] as $desc)
                            <li class="activity-item">
                                <span class="activity-icon">•</span>
                                <div>
                                    {{-- Ensure you use 'title' and 'description' keys from the DayDescription model --}}
                                    <strong>{{ $desc['title'] ?? 'Activity' }}</strong><br>
                                    <span style="color: #6c757d;">{{ $desc['description'] ?? 'No description' }}</span>
                                </div>
                            </li>
                            @endforeach
                        </ul>
                    @endif

                    @if(!empty($day['services']))
                    <h4 style="color: #2c3e50; margin: 15px 0 10px 0;">🚌 Services Included</h4>
                    <ul class="activity-list">
                        @foreach($day['services'] as $service)
                        <li class="activity-item">
                            <span class="activity-icon">•</span>
                            **{{ $service['service']['name'] ?? 'Service' }}** (Qty: {{ $service['qty'] ?? 1 }})
                        </li>
                        @endforeach
                    </ul>
                    @endif

                    @if(!empty($day['hotels']))
                    <h4 style="color: #2c3e50; margin: 15px 0 10px 0;">🏨 Accommodation</h4>
                    <ul class="activity-list">
                        @foreach($day['hotels'] as $hotel)
                        <li class="activity-item">
                            <span class="activity-icon">•</span>
                            **{{ $hotel['hotel']['name'] ?? 'Hotel' }}** • {{ $hotel['room_type'] ?? 'Standard' }} (Rooms: {{ $hotel['qty'] ?? 1 }})
                        </li>
                        @endforeach
                    </ul>
                    @endif

                    @if(!empty($day['extra_services']))
                    <h4 style="color: #2c3e50; margin: 15px 0 10px 0;">➕ Additional Services</h4>
                    <ul class="activity-list">
                        @foreach($day['extra_services'] as $extra)
                        <li class="activity-item">
                            <span class="activity-icon">•</span>
                            {{ $extra['name'] ?? 'Extra Service' }} (Qty: {{ $extra['qty'] ?? 1 }})
                        </li>
                        @endforeach
                    </ul>
                    @endif
                </div>
            </div>
            @endforeach
        </div>

                <div class="content-section">
            <div class="section-title">
                📋 IMPORTANT INFORMATION
            </div>
            
            <div style="display: grid; gap: 20px;">
                <div>
                    <h4 style="color: #2c3e50; margin-bottom: 10px;">✅ What's Included</h4>
                    <div style="background: #d4edda; padding: 15px; border-radius: 8px; color: #155724;">
                        {{ $invoice['includes'] ?? 'All services, accommodations, and activities as mentioned in the itinerary.' }}
                    </div>
                </div>
                
                <div>
                    <h4 style="color: #2c3e50; margin-bottom: 10px;">❌ What's Not Included</h4>
                    <div style="background: #f8d7da; padding: 15px; border-radius: 8px; color: #721c24;">
                        {{ $invoice['excludes'] ?? 'Personal expenses, travel insurance, and any services not mentioned above.' }}
                    </div>
                </div>
                
                <div>
                    <h4 style="color: #2c3e50; margin-bottom: 10px;">📜 Terms & Conditions</h4>
                    <div style="background: #fff3cd; padding: 15px; border-radius: 8px; color: #856404;">
                        {{ $invoice['terms_and_conditions'] ?? 'Standard terms and conditions apply. Please refer to our policy document for detailed information.' }}
                    </div>
                </div>
                
                <div>
                    <h4 style="color: #2c3e50; margin-bottom: 10px;">💵 Refund Policy</h4>
                    <div style="background: #d1ecf1; padding: 15px; border-radius: 8px; color: #0c5460;">
                        {{ $invoice['refund_policy'] ?? 'Refund policy applies as per company norms. Cancellation charges may apply based on the timing of cancellation.' }}
                    </div>
                </div>
            </div>
        </div>

                <div class="footer">
            <div class="footer-logo">{{ $travelAgent['name'] ?? 'Travel Agency' }}</div>
            <div class="thank-you">Thank you for choosing us for your travel needs!</div>
            <div style="color: #bdc3c7; font-size: 0.9em; margin-top: 10px;">
                This itinerary was prepared by {{ $user['name'] ?? 'Travel Agent' }} on {{ $currentDate ?? date('F j, Y') }}
            </div>
            <div style="margin-top: 20px; padding-top: 20px; border-top: 1px solid #34495e;">
                <div style="color: #95a5a6; font-size: 0.8em;">
                    For any queries, please contact us at {{ $travelAgent['phone'] ?? 'N/A' }} or {{ $travelAgent['email'] ?? 'N/A' }}
                </div>
            </div>
        </div>
    </div>
</body>
</html>
