<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\TravelAgentController;
use App\Http\Controllers\ServiceController;
use App\Http\Controllers\HotelController;
use App\Http\Controllers\ExtraServiceController;
use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\InvoiceDayController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\CompanyController;
use App\Http\Controllers\DayDescriptionController;
use App\Http\Controllers\AiGenerationController;
use App\Http\Controllers\SubscriptionController;
use App\Http\Controllers\TripPaymentController;
use App\Http\Controllers\MailConfigController;
use App\Http\Controllers\EmailController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\AppDashboardController;

// ==================== Sessinoal Price IMPORTS ====================
use App\Http\Controllers\SeasonalCalendarController;

// ==================== SUPERADMIN IMPORTS ====================
use App\Http\Controllers\SuperAdmin\AuthController as SuperAdminAuthController;
use App\Http\Controllers\SuperAdmin\DashboardController;
use App\Http\Controllers\SuperAdmin\TravelAgentController as SuperAdminTravelAgentController;
use App\Http\Controllers\SuperAdmin\UserManagementController;
use App\Http\Controllers\SuperAdmin\SubscriptionPlanController;
use App\Http\Controllers\SuperAdmin\TopUpController;
use App\Http\Controllers\SuperAdmin\PaymentAnalyticsController;
use App\Http\Controllers\SuperAdmin\AiUsageController;
use App\Http\Controllers\SuperAdmin\SystemSettingController;

// Test Route
Route::get('test', function () {
    return response()->json(['message' => 'API working!']);
});

// ==================== SUPERADMIN AUTH ROUTES ====================
Route::prefix('superadmin')->group(function () {
    Route::post('login', [SuperAdminAuthController::class, 'login']);
    
    Route::middleware(['auth:sanctum', 'superadmin'])->group(function () {
        Route::get('me', [SuperAdminAuthController::class, 'me']);
        Route::post('logout', [SuperAdminAuthController::class, 'logout']);
        Route::get('login-history', [SuperAdminAuthController::class, 'loginHistory']);
        
        // Dashboard
        Route::get('dashboard/stats', [DashboardController::class, 'stats']);
        Route::get('dashboard/chart-data', [DashboardController::class, 'chartData']);
        
        // Travel Agent Management
        Route::apiResource('travel-agents', SuperAdminTravelAgentController::class);
        Route::post('travel-agents/{id}/toggle-status', [SuperAdminTravelAgentController::class, 'toggleStatus']);
        Route::get('travel-agents/{id}/users', [SuperAdminTravelAgentController::class, 'getAgentUsers']);
        Route::get('travel-agents/{id}/stats', [SuperAdminTravelAgentController::class, 'getAgentStats']);
        
        // User Management
        Route::get('users', [UserManagementController::class, 'index']);
        Route::put('users/{id}', [UserManagementController::class, 'update']);
        Route::post('users/{id}/toggle-status', [UserManagementController::class, 'toggleStatus']);
        
        // ==================== PHASE 3 ROUTES ====================
        
        // Subscription Plan Management
        Route::apiResource('subscription-plans', SubscriptionPlanController::class);
        Route::post('subscription-plans/{id}/toggle-status', [SubscriptionPlanController::class, 'toggleStatus']);
        
        // Top-up Management
        Route::apiResource('top-ups', TopUpController::class);
        Route::post('top-ups/{id}/toggle-status', [TopUpController::class, 'toggleStatus']);
        Route::post('top-ups/{id}/set-best-value', [TopUpController::class, 'setBestValue']);
        
        // Payment Analytics
        Route::get('payments/overview', [PaymentAnalyticsController::class, 'overview']);
        Route::get('payments/revenue-chart', [PaymentAnalyticsController::class, 'revenueChart']);
        Route::get('payments/top-agents', [PaymentAnalyticsController::class, 'topAgentsByRevenue']);
        
        // AI Usage Monitoring
        Route::get('ai-usage', [AiUsageController::class, 'index']);
        Route::get('ai-usage/analytics', [AiUsageController::class, 'analytics']);
        Route::get('ai-usage/top-users', [AiUsageController::class, 'topUsers']);
        
        // System Settings
        Route::get('system-settings', [SystemSettingController::class, 'index']);
        Route::put('system-settings', [SystemSettingController::class, 'update']);
        Route::get('system-config', [SystemSettingController::class, 'getConfig']);
    });
});


// Auth APIs (Public)
// New route to handle Firebase ID Token verification
Route::post('firebase-auth', [AuthController::class, 'firebaseAuth']);
Route::post('request-otp', [AuthController::class, 'requestOtp']);
Route::post('verify-otp', [AuthController::class, 'verifyOtp']);
Route::post('login-pin', [AuthController::class, 'loginWithPin']);
Route::post('login-password', [AuthController::class, 'loginWithPassword']);

// Public routes that might be needed
Route::get('services/search', [ServiceController::class, 'search']);
Route::get('hotels/search', [HotelController::class, 'search']);
Route::get('extra-services/search', [ExtraServiceController::class, 'search']);

// Protected routes (require authentication)
Route::middleware('auth:sanctum')->group(function () {
    
    // Auth related
    Route::post('set-pin', [AuthController::class, 'setPin']);
    Route::post('logout', [AuthController::class, 'logout']);
    Route::get('/user/profile', [AuthController::class, 'profile']);

    // --- ADMIN ROUTES ---
    // You MUST create the 'admin.check' middleware (or similar)
    Route::middleware('admin.check')->prefix('admin')->group(function () {
        // Standard CRUD for users
        Route::apiResource('users', UserController::class); 
        
        // Dedicated endpoint for Requirement 2 & 3
        Route::post('users/{user}/toggle-status', [UserController::class, 'toggleStatus']);
    });

    //mail server configaration
    Route::post('/mail-config', [MailConfigController::class, 'storeOrUpdate']);
    Route::get('/mail-config/{travel_agent_id}', [MailConfigController::class, 'show']);

    // Email sending routes
    Route::post('/send-email/html', [EmailController::class, 'sendHtmlEmail']);
    Route::post('/send-email/template', [EmailController::class, 'sendTemplateEmail']);
    Route::post('/send-email/trip-plan', [EmailController::class, 'sendTripPlanEmail']);
    
    // Company
    Route::get('/company/{id}', [CompanyController::class, 'show']);
    
    // Invoices
    Route::get('invoices/{invoice}/details', [InvoiceController::class, 'details']);
    Route::post('invoices/{invoice}/send-whatsapp', [InvoiceController::class, 'sendWhatsapp']);
    Route::post('invoices/{invoice}/send-email', [InvoiceController::class, 'sendEmail']);
    Route::post('invoices/{invoice}/generate-pdf', [InvoiceController::class, 'generatePdf']);
    //Route::post('invoices/{id}/convert', [InvoiceController::class, 'convertToBilling']);
    Route::post('trip-pos/invoice', [InvoiceController::class, 'createFullInvoice']);
    Route::get('invoices/customer/{customerId}', [InvoiceController::class, 'getCustomerInvoices']);
    Route::apiResource('invoices', InvoiceController::class);

    // FIXED: Invoices - Updated routes to handle URL-encoded trip codes
    Route::get('invoices/trip-code/{tripCode}', [InvoiceController::class, 'getByTripCode'])->where('tripCode', '.*');
    Route::get('invoices/search/trip-code', [InvoiceController::class, 'searchByTripCode']);
    Route::get('invoices/analytics/seasonal', [InvoiceController::class, 'getSeasonalAnalytics']);
    Route::get('invoices/trip-code/{tripCode}/verify-calculations', [InvoiceController::class, 'verifyCalculationConsistency'])->where('tripCode', '.*');

    //AI Trip Plan
    Route::post('/ai/generate-trip-plan', [AiGenerationController::class, 'generateTripPlan']);

    // Seasonal Calendar Routes
    Route::prefix('seasonal')->group(function () {
        // CRUD operations
        Route::get('/calendars', [SeasonalCalendarController::class, 'index']);
        Route::post('/calendars', [SeasonalCalendarController::class, 'store']);
        Route::put('/calendars/{id}', [SeasonalCalendarController::class, 'update']);
        Route::delete('/calendars/{id}', [SeasonalCalendarController::class, 'destroy']);

        // Price calculations
        Route::post('/calculate-price', [SeasonalCalendarController::class, 'calculatePrice']);
        Route::post('/calculate-bulk-prices', [SeasonalCalendarController::class, 'calculateBulkPrices']);

        // Calendar views
        Route::get('/calendar/{year}', [SeasonalCalendarController::class, 'getCalendar']);
        Route::get('/calendar/{year}/{month}', [SeasonalCalendarController::class, 'getCalendar']);

        // Cache management
        Route::post('/pre-cache/{year}', [SeasonalCalendarController::class, 'preCache']);
    });


    // App Dashboard Analytics Routes
    Route::prefix('dashboard')->group(function () {
        Route::get('total-overview', [AppDashboardController::class, 'getTotalOverview']);
        Route::get('today-tomorrow-stats', [AppDashboardController::class, 'getTodayTomorrowStats']);
        Route::get('monthly-charts', [AppDashboardController::class, 'getMonthlyCharts']);
        
        // Report Routes
        Route::get('reports/pending-dues', [AppDashboardController::class, 'getPendingDuesReport']);
        Route::get('reports/today-quotations', [AppDashboardController::class, 'getTodayQuotationsReport']);
        Route::get('reports/today-billings', [AppDashboardController::class, 'getTodayBillingsReport']);
        Route::get('reports/today-payments', [AppDashboardController::class, 'getTodayPaymentsReport']);
        Route::get('reports/today-trip-start', [AppDashboardController::class, 'getTodayTripStartReport']);
        Route::get('reports/today-trip-end', [AppDashboardController::class, 'getTodayTripEndReport']);
        Route::get('reports/tomorrow-trip-start', [AppDashboardController::class, 'getTomorrowTripStartReport']);
        Route::get('reports/tomorrow-trip-end', [AppDashboardController::class, 'getTomorrowTripEndReport']);
    });
    
    // Day Descriptions
    Route::apiResource('day-descriptions', DayDescriptionController::class);
    Route::get('day-descriptions/search', [DayDescriptionController::class, 'search']);

    // Invoices - Add these new routes
    Route::post('invoices/{invoice}/cancel', [InvoiceController::class, 'cancelInvoice']);
    Route::post('invoices/{invoice}/convert', [InvoiceController::class, 'convertToBilling']);
    
    // Trip Payments routes
    Route::get('invoices/{invoice}/trip-payments', [TripPaymentController::class, 'index']);
    Route::post('invoices/{invoice}/trip-payments', [TripPaymentController::class, 'store']);
    Route::post('invoices/{invoice}/process-trip-refund', [TripPaymentController::class, 'processRefund']);
    Route::get('invoices/{invoice}/payment-stats', [TripPaymentController::class, 'getPaymentStats']);
    
    // AI Generation Routes
    Route::post('/ai/generate-description', [AiGenerationController::class, 'generateDescription']);
    Route::post('/ai/generate-itinerary', [AiGenerationController::class, 'generateItinerary']);
    Route::post('/ai/usage-stats', [AiGenerationController::class, 'getUsageStats']);
    Route::post('/ai/test-connection', [AiGenerationController::class, 'testConnection']);

    Route::prefix('razorpay')->group(function () {
        Route::post('order', [App\Http\Controllers\RazorpayController::class, 'createOrder']);
        Route::post('verify', [App\Http\Controllers\RazorpayController::class, 'verifyPayment']);
    });

    Route::get('subscription/top-ups', [App\Http\Controllers\SubscriptionController::class, 'getTopUpOptions']);

    // Ensure the existing plans route is correct
    Route::get('subscription/plans', [App\Http\Controllers\SubscriptionController::class, 'getPlans']);
    
    // Subscription Management
    Route::prefix('subscription')->group(function () {
        Route::get('/plans', [SubscriptionController::class, 'getPlans']);
        Route::get('/current', [SubscriptionController::class, 'getCurrentPlan']);
        Route::get('/usage', [SubscriptionController::class, 'getUsage']);
        Route::post('/subscribe', [SubscriptionController::class, 'subscribe']);
        Route::post('/cancel', [SubscriptionController::class, 'cancelSubscription']);
        Route::post('/top-up', [SubscriptionController::class, 'topUp']);
        Route::post('/change-plan', [SubscriptionController::class, 'changePlan']);
        Route::get('/test-scenarios', [SubscriptionController::class, 'testSubscriptionScenarios']); // TEST ONLY
         Route::post('/reset-free', [SubscriptionController::class, 'resetToFree']); // Testing only
    });
    
    // Resource routes
    Route::apiResource('travel-agents', TravelAgentController::class);
    Route::apiResource('services', ServiceController::class);
    Route::apiResource('hotels', HotelController::class);
    Route::apiResource('extra-services', ExtraServiceController::class);
    Route::apiResource('customers', CustomerController::class);
    Route::apiResource('invoice-days', InvoiceDayController::class);
});

// Public routes for invoice days (if needed without auth)
Route::post('invoice-days/{day}/add-service', [InvoiceDayController::class, 'addService']);
Route::post('invoice-days/{day}/add-hotel', [InvoiceDayController::class, 'addHotel']);
Route::post('invoice-days/{day}/add-extra-service', [InvoiceDayController::class, 'addExtraService']);
Route::get('invoice-days/{day}/services', [InvoiceDayController::class, 'getServices']);
Route::get('invoice-days/{day}/hotels', [InvoiceDayController::class, 'getHotels']);
Route::get('invoice-days/{day}/extra-services', [InvoiceDayController::class, 'getExtraServices']);