<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Trip Plan - <?php echo e($invoice['package_name'] ?? 'Travel Package'); ?></title>
    <style type="text/css">
        /* Basic Client Reset */
        body, table, td, a { -webkit-text-size-adjust: 100%; -ms-text-size-adjust: 100%; }
        table, td { mso-table-lspace: 0pt; mso-table-rspace: 0pt; }
        img { -ms-interpolation-mode: bicubic; }
        
        /* Utility Classes (Inline styles preferred, but useful for links/buttons) */
        a { text-decoration: none; color: #00D1C1; }
        
        /* Color Palette */
        .color-dark-bg { background-color: #1A1A2E !important; }
        .color-accent { color: #00D1C1 !important; }
        
        /* Ensure table padding/spacing is correctly zeroed out for cleaner design */
        .full-width-table { width: 100%; border-spacing: 0; border-collapse: collapse; }
    </style>
</head>
<body style="margin: 0; padding: 0; background-color: #1A1A2E; font-family: Arial, sans-serif;">

    <table role="presentation" class="full-width-table" style="padding: 20px 10px;">
        <tr>
            <td align="center">
                <table role="presentation" align="center" border="0" cellpadding="0" cellspacing="0" width="600" style="max-width: 600px; background-color: #FFFFFF; border: 1px solid #1A1A2E; border-collapse: collapse;">
                    
                    <tr>
                        <td class="color-dark-bg" style="padding: 20px 30px; text-align: center;">
                            <!-- Company Name -->
                            <div class="company-name color-accent" style="font-size: 26px; font-weight: 800; margin-bottom: 5px; letter-spacing: 1px;">
                                <?php echo e($travelAgent['name'] ?? 'PREMIUM TRAVEL AGENCY'); ?>

                            </div>

                            <!-- Tagline -->
                            <div style="font-size: 14px; color: #F0F0F0; opacity: 0.8; margin-bottom: 12px;">
                                Crafting Unforgettable Journeys, One Destination at a Time
                            </div>

                            <!-- Contact Info (centered, stacked) -->
                            <table role="presentation" align="center" border="0" cellpadding="0" cellspacing="6" style="margin: 0 auto;">
                                <!-- <?php if(!empty($travelAgent['phone'])): ?>
                                <tr>
                                    <td style="font-size: 13px; color: #F0F0F0; background: rgba(255,255,255,0.05); padding: 6px 12px; border-radius: 4px; line-height: 1.2; text-align: center;">
                                        📞 <?php echo e($travelAgent['phone']); ?>

                                    </td>
                                </tr>
                                <?php endif; ?>

                                <?php if(!empty($travelAgent['email'])): ?>
                                <tr>
                                    <td style="font-size: 13px; color: #F0F0F0; background: rgba(255,255,255,0.05); padding: 6px 12px; border-radius: 4px; line-height: 1.2; text-align: center;">
                                        ✉️ <?php echo e($travelAgent['email']); ?>

                                    </td>
                                </tr>
                                <?php endif; ?> -->

                                <?php if(!empty($travelAgent['address'])): ?>
                                <tr>
                                    <td style="font-size: 13px; color: #F0F0F0; background: rgba(255,255,255,0.05); padding: 6px 12px; border-radius: 4px; line-height: 1.2; text-align: center;">
                                        📍 <?php echo e($travelAgent['address']); ?>

                                    </td>
                                </tr>
                                <?php endif; ?>

                                <?php if(!empty($travelAgent['gst_number'])): ?>
                                <tr>
                                    <td style="font-size: 13px; color: #F0F0F0; background: rgba(255,255,255,0.05); padding: 6px 12px; border-radius: 4px; line-height: 1.2; text-align: center;">
                                        🏢 GST: <?php echo e($travelAgent['gst_number']); ?>

                                    </td>
                                </tr>
                                <?php endif; ?>
                            </table>
                        </td>
                    </tr>


                    <tr>
                        <td style="padding: 25px 30px; border-bottom: 1px solid #E0E0E0;">
                            <div style="font-size: 18px; font-weight: 700; color: #1A1A2E; margin-bottom: 15px; padding-bottom: 8px; border-bottom: 2px solid #E0E0E0; position: relative;">
                                ✈️ TRIP OVERVIEW
                                <div style="position: absolute; bottom: -2px; left: 0; width: 40px; height: 2px; background: #00D1C1;"></div>
                            </div>
                            
                            <table role="presentation" class="full-width-table" style="background-color: #FAFAFA; border: 1px solid #E0E0E0; padding: 15px 10px; text-align: center;">
                                <tr>
                                    <td align="center">
                                        <div style="font-size: 22px; font-weight: 800; color: #1A1A2E; margin-bottom: 5px;"><?php echo e($invoice['package_name'] ?? 'Premium Travel Package'); ?></div>
                                        <h3><?php echo e($invoice['trip_code']); ?></h3>
                                        <div style="font-size: 14px; color: #666; margin-bottom: 20px;">Your journey of a lifetime begins here</div>

                                        <table role="presentation" border="0" cellpadding="0" cellspacing="10" width="100%">
                                            <tr>
                                                <td width="25%" align="center" style="padding: 0;">
                                                    <table role="presentation" class="full-width-table" style="background: #FFFFFF; padding: 10px; border: 1px solid #E0E0E0; text-align: center;">
                                                        <tr>
                                                            <td style="font-size: 13px; color: #666; font-weight: 500; text-transform: uppercase;">Trip Duration</td>
                                                        </tr>
                                                        <tr>
                                                            <td class="color-accent" style="font-size: 18px; font-weight: 700; padding: 4px 0;"><?php echo e(count($invoice['trip_days'] ?? [])); ?> Days</td>
                                                        </tr>
                                                    </table>
                                                </td>
                                                <td width="25%" align="center" style="padding: 0;">
                                                    <table role="presentation" class="full-width-table" style="background: #FFFFFF; padding: 10px; border: 1px solid #E0E0E0; text-align: center;">
                                                        <tr>
                                                            <td style="font-size: 13px; color: #666; font-weight: 500; text-transform: uppercase;">Travelers</td>
                                                        </tr>
                                                        <tr>
                                                            <td class="color-accent" style="font-size: 18px; font-weight: 700; padding: 4px 0;"><?php echo e($invoice['no_of_pax'] ?? 0); ?> PAX</td>
                                                        </tr>
                                                    </table>
                                                </td>
                                                <td width="25%" align="center" style="padding: 0;">
                                                    <table role="presentation" class="full-width-table" style="background: #FFFFFF; padding: 10px; border: 1px solid #E0E0E0; text-align: center;">
                                                        <tr>
                                                            <td style="font-size: 13px; color: #666; font-weight: 500; text-transform: uppercase;">Start Date</td>
                                                        </tr>
                                                        <tr>
                                                            <td class="color-accent" style="font-size: 18px; font-weight: 700; padding: 4px 0;"><?php echo e($startDate ?? 'TBD'); ?></td>
                                                        </tr>
                                                    </table>
                                                </td>
                                                <td width="25%" align="center" style="padding: 0;">
                                                    <table role="presentation" class="full-width-table" style="background: #FFFFFF; padding: 10px; border: 1px solid #E0E0E0; text-align: center;">
                                                        <tr>
                                                            <td style="font-size: 13px; color: #666; font-weight: 500; text-transform: uppercase;">End Date</td>
                                                        </tr>
                                                        <tr>
                                                            <td class="color-accent" style="font-size: 18px; font-weight: 700; padding: 4px 0;"><?php echo e($endDate ?? 'TBD'); ?></td>
                                                        </tr>
                                                    </table>
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>

                    <tr>
                        <td style="padding: 25px 30px; border-bottom: 1px solid #E0E0E0; background-color: #FAFAFA;">
                            <div style="font-size: 18px; font-weight: 700; color: #1A1A2E; margin-bottom: 15px; padding-bottom: 8px; border-bottom: 2px solid #E0E0E0; position: relative;">
                                👤 GUEST INFORMATION
                                <div style="position: absolute; bottom: -2px; left: 0; width: 40px; height: 2px; background: #00D1C1;"></div>
                            </div>
                            
                            <table role="presentation" border="0" cellpadding="0" cellspacing="10" width="100%">
                                <tr>
                                    <td width="50%" align="left" valign="top" style="padding: 0;">
                                        <table role="presentation" class="full-width-table" style="background: white; padding: 12px; border: 1px solid #E0E0E0; border-left: 4px solid #00D1C1;">
                                            <tr>
                                                <td width="30" style="padding: 0;">
                                                    <div style="width: 30px; height: 30px; background-color: #00D1C1; color: white; border-radius: 50%; font-size: 18px; line-height: 30px; text-align: center;">👤</div>
                                                </td>
                                                <td style="padding: 0 0 0 10px;">
                                                    <div style="font-weight: 600; font-size: 15px; color: #1A1A2E;"><?php echo e($invoice['customer_name'] ?? 'Valued Customer'); ?></div>
                                                    <div style="color: #666; font-size: 13px;">Primary Guest</div>
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                    <td width="50%" align="left" valign="top" style="padding: 0;">
                                        <table role="presentation" class="full-width-table" style="background: white; padding: 12px; border: 1px solid #E0E0E0; border-left: 4px solid #00D1C1;">
                                            <tr>
                                                <td width="30" style="padding: 0;">
                                                    <div style="width: 30px; height: 30px; background-color: #00D1C1; color: white; border-radius: 50%; font-size: 18px; line-height: 30px; text-align: center;">📞</div>
                                                </td>
                                                <td style="padding: 0 0 0 10px;">
                                                    <div style="font-weight: 600; font-size: 15px; color: #1A1A2E;"><?php echo e($invoice['customer_phone_number'] ?? 'Not Provided'); ?></div>
                                                    <div style="color: #666; font-size: 13px;">Phone Number</div>
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                                <tr>
                                    <td width="50%" align="left" valign="top" style="padding: 0;">
                                        <table role="presentation" class="full-width-table" style="background: white; padding: 12px; border: 1px solid #E0E0E0; border-left: 4px solid #00D1C1;">
                                            <tr>
                                                <td width="30" style="padding: 0;">
                                                    <div style="width: 30px; height: 30px; background-color: #00D1C1; color: white; border-radius: 50%; font-size: 18px; line-height: 30px; text-align: center;">✉️</div>
                                                </td>
                                                <td style="padding: 0 0 0 10px;">
                                                    <div style="font-weight: 600; font-size: 15px; color: #1A1A2E;"><?php echo e($invoice['customer_email'] ?? 'Not Provided'); ?></div>
                                                    <div style="color: #666; font-size: 13px;">Email Address</div>
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                    <td width="50%" align="left" valign="top" style="padding: 0;">
                                        <table role="presentation" class="full-width-table" style="background: white; padding: 12px; border: 1px solid #E0E0E0; border-left: 4px solid #00D1C1;">
                                            <tr>
                                                <td width="30" style="padding: 0;">
                                                    <div style="width: 30px; height: 30px; background-color: #00D1C1; color: white; border-radius: 50%; font-size: 18px; line-height: 30px; text-align: center;">💬</div>
                                                </td>
                                                <td style="padding: 0 0 0 10px;">
                                                    <div style="font-weight: 600; font-size: 15px; color: #1A1A2E;"><?php echo e($invoice['customer_whatsapp'] ?? 'Not Provided'); ?></div>
                                                    <div style="color: #666; font-size: 13px;">WhatsApp</div>
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>

                    <tr>
                        <td style="padding: 25px 30px; border-bottom: 1px solid #E0E0E0;">
                            <div style="font-size: 18px; font-weight: 700; color: #1A1A2E; margin-bottom: 15px; padding-bottom: 8px; border-bottom: 2px solid #E0E0E0; position: relative;">
                                💰 PRICE BREAKDOWN
                                <div style="position: absolute; bottom: -2px; left: 0; width: 40px; height: 2px; background: #00D1C1;"></div>
                            </div>
                            
                            <table role="presentation" class="full-width-table" border="0" cellpadding="0" cellspacing="0" style="margin: 15px 0; border: 1px solid #E0E0E0; border-collapse: collapse;">
                                <tr>
                                    <td style="padding: 10px 15px; border-bottom: 1px solid #E0E0E0; font-size: 14px;">Total Package Amount</td>
                                    <td align="right" style="padding: 10px 15px; border-bottom: 1px solid #E0E0E0; font-size: 14px; font-weight: 600; color: #28A745;">₹<?php echo e(number_format(($invoice['billed_amount'] ?? 0) + ($invoice['margin_amount'] ?? 0), 2)); ?></td>
                                </tr>
                                <tr>
                                    <td style="padding: 10px 15px; border-bottom: 1px solid #E0E0E0; font-size: 14px;">Tax (<?php echo e($invoice['tax_percentage'] ?? 0); ?>%)</td>
                                    <td align="right" style="padding: 10px 15px; border-bottom: 1px solid #E0E0E0; font-size: 14px; font-weight: 600; color: #28A745;">₹<?php echo e(number_format($invoice['tax_amount'] ?? 0, 2)); ?></td>
                                </tr>
                                <tr>
                                    <td style="padding: 10px 15px; border-bottom: 1px solid #E0E0E0; font-size: 14px;">Discount Applied</td>
                                    <td align="right" style="padding: 10px 15px; border-bottom: 1px solid #E0E0E0; font-size: 14px; font-weight: 600; color: #DC3545;">-₹<?php echo e(number_format($invoice['discount_amount'] ?? 0, 2)); ?></td>
                                </tr>
                                <tr class="color-dark-bg">
                                    <td style="padding: 12px 15px; font-size: 16px; font-weight: 700; background-color: #1A1A2E; color: #00D1C1;"><strong>Final Amount Payable</strong></td>
                                    <td align="right" style="padding: 12px 15px; font-size: 16px; font-weight: 700; background-color: #1A1A2E; color: #00D1C1;"><strong>₹<?php echo e(number_format($invoice['final_price'] ?? 0, 2)); ?></strong></td>
                                </tr>
                                <tr>
                                    <td style="padding: 10px 15px; font-size: 14px;">Per Person Cost</td>
                                    <td align="right" style="padding: 10px 15px; font-size: 14px; font-weight: 600; color: #1A1A2E;">₹<?php echo e(number_format(($invoice['final_price'] ?? 0) / max(1, ($invoice['no_of_pax'] ?? 1)), 2)); ?></td>
                                </tr>
                            </table>
                        </td>
                    </tr>

                    <tr>
                        <td style="padding: 25px 30px; border-bottom: 1px solid #E0E0E0; background-color: #FAFAFA;">
                            <div style="font-size: 18px; font-weight: 700; color: #1A1A2E; margin-bottom: 15px; padding-bottom: 8px; border-bottom: 2px solid #E0E0E0; position: relative;">
                                💳 PAYMENT INFORMATION
                                <div style="position: absolute; bottom: -2px; left: 0; width: 40px; height: 2px; background: #00D1C1;"></div>
                            </div>
                            
                            <table role="presentation" class="full-width-table" style="background: white; border: 1px solid #E0E0E0; padding: 15px; margin: 15px 0;">
                                <tr>
                                    <td style="padding: 0;">
                                        <table role="presentation" border="0" cellpadding="0" cellspacing="10" width="100%">
                                            <tr>
                                                <td width="33.33%" align="center" style="padding: 0;">
                                                    <table role="presentation" class="full-width-table" style="background: #FAFAFA; padding: 10px 5px; border: 1px solid #E0E0E0; text-align: center;">
                                                        <tr><td style="font-size: 13px; color: #666; padding: 0 0 2px;">Total Amount</td></tr>
                                                        <tr><td style="font-size: 16px; font-weight: 700; color: #1A1A2E;">₹<?php echo e(number_format($invoice['final_price'] ?? 0, 2)); ?></td></tr>
                                                    </table>
                                                </td>
                                                <td width="33.33%" align="center" style="padding: 0;">
                                                    <table role="presentation" class="full-width-table" style="background: #FAFAFA; padding: 10px 5px; border: 1px solid #E0E0E0; text-align: center;">
                                                        <tr><td style="font-size: 13px; color: #666; padding: 0 0 2px;">Amount Paid</td></tr>
                                                        <tr><td style="font-size: 16px; font-weight: 700; color: #28A745;">₹<?php echo e(number_format($invoice['total_paid_amount'] ?? 0, 2)); ?></td></tr>
                                                    </table>
                                                </td>
                                                <td width="33.33%" align="center" style="padding: 0;">
                                                    <table role="presentation" class="full-width-table" style="background: #FAFAFA; padding: 10px 5px; border: 1px solid #E0E0E0; text-align: center;">
                                                        <tr><td style="font-size: 13px; color: #666; padding: 0 0 2px;">Balance Due</td></tr>
                                                        <tr><td style="font-size: 16px; font-weight: 700; color: #DC3545;">₹<?php echo e(number_format($invoice['remaining_amount'] ?? 0, 2)); ?></td></tr>
                                                    </table>
                                                </td>
                                            </tr>
                                        </table>
                                        
                                        <table role="presentation" class="full-width-table" style="background: #E5E7EB; margin: 10px 0; height: 6px;">
                                            <tr>
                                                <td width="<?php echo e($paymentPercentage ?? 0); ?>%" style="background-color: #00D1C1; height: 6px;"></td>
                                                <td width="<?php echo e(100 - ($paymentPercentage ?? 0)); ?>%" style="background-color: #E5E7EB; height: 6px;"></td>
                                            </tr>
                                        </table>

                                        <div style="text-align: center; font-size: 14px; padding-top: 5px;">
                                            <span style="font-weight: 600; color: #333;"><?php echo e(number_format($paymentPercentage ?? 0, 1)); ?>% Paid • </span>
                                            <span style="font-weight: 600; color: <?php echo e(($paymentPercentage ?? 0) >= 100 ? '#28A745' : '#DC3545'); ?>;"><?php echo e($invoice['payment_status'] ?? 'Pending'); ?></span>
                                        </div>
                                    </td>
                                </tr>
                            </table>

                            <?php if(!empty($payments) && count($payments) > 0): ?>
                            <div style="margin-top: 20px;">
                                <h4 style="color: #1A1A2E; margin-bottom: 10px; font-size: 17px; font-weight: 700; border-bottom: 1px solid #E0E0E0; padding-bottom: 5px;">📋 Payment History</h4>
                                <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div style="padding: 10px; border: 1px solid #E0E0E0; border-left: 4px solid #00D1C1; margin-bottom: 8px; background-color: #FFFFFF;">
                                    <table role="presentation" class="full-width-table">
                                        <tr>
                                            <td style="font-weight: 600; color: #1A1A2E; font-size: 14px; padding: 0; line-height: 1.2;"><?php echo e($payment['type'] ?? 'Payment'); ?></td>
                                            <td align="right" style="font-weight: 700; color: #28A745; font-size: 14px; padding: 0; line-height: 1.2;">₹<?php echo e(number_format($payment['amount'] ?? 0, 2)); ?></td>
                                        </tr>
                                        <tr>
                                            <td style="font-size: 13px; color: #666; padding: 3px 0 0;">Method: <?php echo e($payment['payment_method'] ?? 'N/A'); ?></td>
                                            <td align="right" style="font-size: 13px; color: #666; padding: 3px 0 0;">Date: <?php echo e($payment['payment_date'] ?? 'N/A'); ?></td>
                                        </tr>
                                        <?php if(!empty($payment['status'])): ?>
                                        <tr>
                                            <td colspan="2" style="padding: 5px 0 0;">
                                                <span style="background: <?php echo e($payment['status'] == 'Completed' ? '#E6F7EF' : '#FFF8E6'); ?>; color: <?php echo e($payment['status'] == 'Completed' ? '#155724' : '#856404'); ?>; padding: 3px 8px; border-radius: 2px; font-size: 12px; font-weight: 600;">
                                                    <?php echo e($payment['status']); ?>

                                                </span>
                                            </td>
                                        </tr>
                                        <?php endif; ?>
                                    </table>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <?php endif; ?>
                        </td>
                    </tr>

                    <tr>
                        <td style="padding: 25px 30px; border-bottom: 1px solid #E0E0E0;">
                            <div style="font-size: 18px; font-weight: 700; color: #1A1A2E; margin-bottom: 20px; padding-bottom: 8px; border-bottom: 2px solid #E0E0E0; position: relative;">
                                📅 DETAILED ITINERARY
                                <div style="position: absolute; bottom: -2px; left: 0; width: 40px; height: 2px; background: #00D1C1;"></div>
                            </div>
                            
                            <?php $__currentLoopData = $invoice['trip_days'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <table role="presentation" class="full-width-table" style="margin-bottom: 20px;">
                                <tr>
                                    <td width="50" valign="top" style="padding: 0;">
                                        <div style="width: 50px; height: 50px; background-color: #00D1C1; color: white; border-radius: 50%; font-weight: 700; font-size: 14px; line-height: 40px; text-align: center; margin-left: 5px;">
                                            Day <?php echo e($day['day_number'] ?? 1); ?>

                                        </div>
                                        <div style="width: 2px; background: #00D1C1; height: 100%; margin: 5px auto 0; font-size: 1px; line-height: 1px;">&nbsp;</div>
                                    </td>
                                    <td valign="top" style="padding: 0 0 0 10px;">
                                        <table role="presentation" class="full-width-table" style="background: white; padding: 15px; border: 1px solid #E0E0E0; border-radius: 4px;">
                                            <tr>
                                                <td style="font-size: 16px; font-weight: 700; color: #1A1A2E; margin-bottom: 10px; padding-bottom: 5px; border-bottom: 1px solid #E0E0E0;">
                                                    <?php echo e($day['day_date'] ?? 'Date not specified'); ?>

                                                </td>
                                            </tr>
                                            <tr>
                                                <td style="padding-top: 10px;">
                                                    <?php if(!empty($day['day_descriptions'])): ?>
                                                    <div style="margin-bottom: 15px;">
                                                        <div style="font-size: 15px; font-weight: 600; color: #1A1A2E; margin-bottom: 8px; border-left: 3px solid #00D1C1; padding-left: 5px;">📝 Day Overview</div>
                                                        <?php $__currentLoopData = $day['day_descriptions']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $desc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div style="padding: 8px 10px; background: #FAFAFA; border-radius: 4px; margin-bottom: 4px; border-left: 3px solid #00D1C1; font-size: 14px; line-height: 1.6;">
                                                            
                                                            <?php
                                                                $formattedDescription = $desc['description'] ?? 'No description available';

                                                                $firstTitle = true; // track first title

                                                                // 1. Convert **Title:** or Title: into styled <strong> with separator line
                                                                $formattedDescription = preg_replace_callback(
                                                                    '/\*{0,2}([^:*]+)\*{0,2}\s*:/',
                                                                    function($matches) use (&$firstTitle) {
                                                                        $cleanTitle = trim($matches[1]);
                                                                        $prefix = $firstTitle ? '' : ''; // no <br>, rely on border-bottom
                                                                        $firstTitle = false;
                                                                        return $prefix .
                                                                               '<div style="margin-top:6px; margin-bottom:2px; padding-bottom:2px; border-bottom:1px solid #ddd;">'
                                                                               . '<strong style="font-style: italic; color:#1A1A2E; line-height:1.4;">' 
                                                                               . $cleanTitle . ':</strong>'
                                                                               . '</div>';
                                                                    },
                                                                    $formattedDescription
                                                                );

                                                                // 2. Handle bullet lists: convert "- item" into <ul><li>
                                                                $formattedDescription = preg_replace_callback(
                                                                    '/(?:^|\n)(-\s.+(?:\n-\s.+)*)/m',
                                                                    function($matches) {
                                                                        $items = explode("\n", trim($matches[1]));
                                                                        $lis = '';
                                                                        foreach ($items as $item) {
                                                                            $lis .= '<li style="margin:0; padding:0;">' . trim(ltrim($item, '- ')) . '</li>';
                                                                        }
                                                                        return '<ul style="margin:0 0 2px 18px; padding:0; list-style-type:disc;">' . $lis . '</ul>';
                                                                    },
                                                                    $formattedDescription
                                                                );

                                                                // 3. Collapse multiple blank lines into one
                                                                $formattedDescription = preg_replace("/(\r?\n){2,}/", "\n", $formattedDescription);

                                                                // 4. Convert remaining newlines to <br>
                                                                $formattedDescription = nl2br($formattedDescription);

                                                                // 5. Wrap everything in justified container
                                                                $formattedDescription = '<div style="text-align: justify; color:#444; font-size:13px; line-height:1.5; margin:0;">'
                                                                                        . $formattedDescription . '</div>';
                                                            ?>

                                                            <strong><?php echo e($desc['title'] ?? 'Activity'); ?></strong>
                                                            <div style="color: #666; font-size: 13px; margin-top: 2px;">
                                                                <?php echo $formattedDescription; ?>

                                                            </div>
                                                        </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </div>
                                                    <?php endif; ?>
                                                    
                                                    <?php if(!empty($day['services'])): ?>
                                                    <div style="margin-bottom: 15px;">
                                                        <div style="font-size: 15px; font-weight: 600; color: #1A1A2E; margin-bottom: 8px; border-left: 3px solid #28A745; padding-left: 5px;">🚌 Included Services</div>
                                                        <?php $__currentLoopData = $day['services']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div style="padding: 8px 10px; background: #FAFAFA; border-radius: 4px; margin-bottom: 4px; border-left: 3px solid #28A745; font-size: 14px;">
                                                            <table role="presentation" class="full-width-table">
                                                                <tr>
                                                                    <td style="font-weight: 600; color: #1A1A2E; padding: 0;">🚌 <?php echo e($service['service']['name'] ?? 'Service'); ?></td>
                                                                    <td align="right" style="padding: 0;">
                                                                        <span style="background: #00D1C1; color: white; padding: 2px 8px; border-radius: 2px; font-size: 12px; font-weight: 600;">Qty: <?php echo e($service['qty'] ?? 1); ?></span>
                                                                    </td>
                                                                </tr>
                                                                <?php if(!empty($service['variation'])): ?>
                                                                <tr>
                                                                    <td colspan="2" style="color: #666; font-size: 13px; padding-top: 2px;">Type: <strong><?php echo e($service['variation']); ?></strong></td>
                                                                </tr>
                                                                <?php endif; ?>
                                                            </table>
                                                        </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </div>
                                                    <?php endif; ?>

                                                    <?php if(!empty($day['hotels'])): ?>
                                                    <div style="margin-bottom: 0;">
                                                        <div style="font-size: 15px; font-weight: 600; color: #1A1A2E; margin-bottom: 8px; border-left: 3px solid #FFC107; padding-left: 5px;">🏨 Accommodation</div>
                                                        <?php $__currentLoopData = $day['hotels']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hotel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div style="padding: 8px 10px; background: #FAFAFA; border-radius: 4px; margin-bottom: 4px; border-left: 3px solid #FFC107; font-size: 14px;">
                                                            <table role="presentation" class="full-width-table">
                                                                <tr>
                                                                    <td style="font-weight: 600; color: #1A1A2E; padding: 0;">🏨 <?php echo e($hotel['hotel']['name'] ?? 'Hotel'); ?></td>
                                                                    <td align="right" style="padding: 0;">
                                                                        <span style="background: #F59E0B; color: white; padding: 2px 8px; border-radius: 2px; font-size: 12px; font-weight: 600;">Rooms: <?php echo e($hotel['qty'] ?? 1); ?></span>
                                                                    </td>
                                                                </tr>
                                                                <?php if(!empty($hotel['room_type'])): ?>
                                                                <tr>
                                                                    <td colspan="2" style="color: #666; font-size: 13px; padding-top: 2px;">Room Type: <strong><?php echo e($hotel['room_type'] ?? 'Standard Room'); ?></strong></td>
                                                                </tr>
                                                                <?php endif; ?>
                                                            </table>
                                                        </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </div>
                                                    <?php endif; ?>

                                                    <?php if(!empty($day['extra_services'])): ?>
                                                    <div style="margin-bottom: 0;">
                                                        <div style="font-size: 15px; font-weight: 600; color: #1A1A2E; margin-bottom: 8px; border-left: 3px solid #ff7007; padding-left: 5px;">➕ Additional Services</div>
                                                        <?php $__currentLoopData = $day['extra_services']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $extra): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div style="padding: 8px 10px; background: #FAFAFA; border-radius: 4px; margin-bottom: 4px; border-left: 3px solid #ff7007; font-size: 14px;">
                                                            <table role="presentation" class="full-width-table">
                                                                <tr>
                                                                    <td style="font-weight: 600; color: #1A1A2E; padding: 0;">⭐ <?php echo e($extra['name'] ?? 'Extra Service'); ?></td>
                                                                    <td align="right" style="padding: 0;">
                                                                        <span style="background: #ff7007; color: white; padding: 2px 8px; border-radius: 2px; font-size: 12px; font-weight: 600;">Qty: <?php echo e($extra['qty'] ?? 1); ?></span>
                                                                    </td>
                                                                </tr>
                                                                
                                                            </table>
                                                        </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </div>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </td>
                    </tr>

                    <tr>
                        <td style="padding: 25px 30px;">
                            <div style="font-size: 18px; font-weight: 700; color: #1A1A2E; margin-bottom: 20px; padding-bottom: 8px; border-bottom: 2px solid #E0E0E0; position: relative;">
                                📋 IMPORTANT INFORMATION
                                <div style="position: absolute; bottom: -2px; left: 0; width: 40px; height: 2px; background: #00D1C1;"></div>
                            </div>

                            <div style="padding: 0;">
                                <div style="padding: 12px; border-radius: 4px; margin-bottom: 15px; font-size: 14px; background: #E6F7EF; color: #155724; border: 1px solid #C3E6CB; border-left: 4px solid #28A745; line-height: 1.5;">
                                    <h4 style="font-size: 16px; font-weight: 700; margin-bottom: 8px; color: #1A1A2E; line-height: 1.2;">✅ What's Included</h4>
                                    <div>
                                        <?php echo e($invoice['includes'] ?? 'All services, accommodations, meals, and activities as specifically mentioned in the itinerary. Professional guide services, entrance fees, and transportation between destinations.'); ?>

                                    </div>
                                </div>
                                
                                <div style="padding: 12px; border-radius: 4px; margin-bottom: 15px; font-size: 14px; background: #FDECEC; color: #721C24; border: 1px solid #F5C6CB; border-left: 4px solid #DC3545; line-height: 1.5;">
                                    <h4 style="font-size: 16px; font-weight: 700; margin-bottom: 8px; color: #1A1A2E; line-height: 1.2;">❌ What's Not Included</h4>
                                    <div>
                                        <?php echo e($invoice['excludes'] ?? 'Personal expenses, travel insurance, visa fees, airport taxes, tips and gratuities, optional activities, and any services not explicitly mentioned in the itinerary.'); ?>

                                    </div>
                                </div>
                                
                                <div style="padding: 12px; border-radius: 4px; margin-bottom: 15px; font-size: 14px; background: #FFF8E6; color: #856404; border: 1px solid #FFEEBA; border-left: 4px solid #FFC107; line-height: 1.5;">
                                    <h4 style="font-size: 16px; font-weight: 700; margin-bottom: 8px; color: #1A1A2E; line-height: 1.2;">📜 Terms & Conditions</h4>
                                    <div>
                                        <?php echo e($invoice['terms_and_conditions'] ?? 'All bookings are subject to availability. Prices are subject to change without notice. Cancellation policies apply as per company guidelines. Force majeure conditions may affect itinerary execution.'); ?>

                                    </div>
                                </div>
                            </div>
                        </td>
                    </tr>

                    <tr>
                        <td class="color-dark-bg" style="background-color: #1A1A2E; padding: 25px 30px; text-align: center; color: #F0F0F0;">
                            <div class="footer-logo color-accent" style="font-size: 24px; font-weight: 800; margin-bottom: 10px;"><?php echo e($travelAgent['name'] ?? 'Premium Travel Agency'); ?></div>
                            <div style="font-size: 16px; margin: 10px 0 15px;">Thank you for trusting us with your travel plans!</div>
                            
                            <div style="color: #AAAAAA; font-size: 13px; margin-top: 10px;">
                                This personalized itinerary was carefully prepared by <?php echo e($user['name'] ?? 'our travel expert'); ?><br>
                                on <?php echo e($currentDate ?? now()->format('F j, Y')); ?>

                            </div>
                            
                            <div style="padding-top: 15px; border-top: 1px solid #333333; margin-top: 15px; font-size: 13px; color: #AAAAAA;">
                                For any questions or special requests, please contact us at:<br>
                                📞 <a href="tel:<?php echo e(preg_replace('/[^\d\+]/', '', $travelAgent['phone'] ?? 'Contact Number')); ?>" style="color: #00D1C1;"><?php echo e($travelAgent['phone'] ?? 'Contact Number'); ?></a> | 
                                ✉️ <a href="mailto:<?php echo e($travelAgent['email'] ?? 'Email Address'); ?>" style="color: #00D1C1;"><?php echo e($travelAgent['email'] ?? 'Email Address'); ?></a>
                            </div>
                            
                            <div style="margin-top: 10px; color: #666; font-size: 12px;">
                                &copy; <?php echo e(date('Y')); ?> <?php echo e($travelAgent['name'] ?? 'Travel Agency'); ?>. All rights reserved.
                            </div>
                        </td>
                    </tr>
                    
                </table>
                </td>
        </tr>
    </table>
    </body>
</html><?php /**PATH C:\xampp\htdocs\web\travel_invoice_saas\resources\views/emails/trip-plan-enhanced.blade.php ENDPATH**/ ?>